
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Dec 14 15:04:40 2004
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief C2cription of this module 
   *
   *  \version CRYS_ATP_TST_C2_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/
#include "CRYS.h"
#include "CRYS_C2.h"
 
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_C2_Acceptance.h"
#include "CRYS_ATP_TST_C2_Acceptance_test_vectors.h"

#include "DX_VOS_Mem.h"
#include <stdio.h>

/************************ Defines ************************/ 
/************************ Enums **************************/ 
/*********************** Typedefs ************************/ 
/************************ Global Data ********************/ 
static CRYS_C2_EncryptMode_t TST_EncryptMode[] = { CRYS_C2_Encrypt , CRYS_C2_Decrypt };
/************* Private function prototype ****************/ 
/************************ Public Functions ***************/ 
/************************ Private Functions **************/ 
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_C2_Acceptance_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * C2cription:                                                                 
 *  This function Is a Acceptance test for C2 non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using C2
 *  C2 moC2                   - CBC/ECB
 *  Vector sizes used (in bytes) - 16/32/512                                 
 *  Key Size used (in bits)     - 128/192/256                               
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the CRYS_C2_Init function to start the encryption/decryption process
 * 2. Call the CRYS_C2_Block - This function is called N times 
 *                              (N = number of blocks in data)
 * 3. Call the CRYS_C2_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one                                                   
 *
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_C2_Acceptance_NON_integrated ( void ) 
{
    /********* TST Variables Definitions ************/
    int                     TST_index, Block_index ,NumOfBlocks;
    CRYSError_t             TST_Status=0;
    int                     TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_C2_Acceptance_NON_integrated"; 
    CRYS_C2CipherUserContext_t   TST_ContextID_ptr;
  

    int TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS=CRYS_C2_BLOCK_SIZE_IN_BYTES;    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ATP_TST_C2_Acceptance_NON_integrated Tests ********************* \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************* \n\n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++) 
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_C2_AcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++)     /*Select mode or operation  
                                                                                                          TST_OperationMode = 0 == Encrypt
                                                                                                          TST_OperationMode = 1 == Decrypt*/
            {           
                                                            
                if (TST_OuputLocation == 0) /*Select output buffer*/
                {   
                    /* output buffer != input buffer    */
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n")); 
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s [test 1A.%d] \n",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_index ));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   output buffer != input buffer                                       \n"));         
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n")); 
                }
                else
                {
                    /* output buffer == input buffer    */
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n")); 
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s [test 1B.%d] \n",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_index));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   output buffer == input buffer (output buffer)                       \n"));                             
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n")); 
                }
                
                TST_Status = TESTPASS;
                        
                /* calling the C2 init function */ 
                /*-------------------------------*/ 
                TST_Status = CRYS_C2_CipherInit(&TST_ContextID_ptr,                                    
                                          &TST_C2_Acceptance_TestData[TST_index].TST_Key,
                                          TST_EncryptMode[TST_ATP_EncryptDecryptFlag], 
                                          TST_C2_Acceptance_TestData[TST_index].TST_OperationMode);                          
                
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2_Init",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
                                                

                
                /* calling the C2 Block function */
                /*--------------------------------*/
                NumOfBlocks = TST_C2_Acceptance_TestData[TST_index].TST_dataSize/TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS;
                
                /* Debug massages */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"number of blocks = %1d \n",NumOfBlocks)); 
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"Input Data Size [byte] = %1d \n" ,TST_C2_Acceptance_TestData[TST_index].TST_dataSize));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"SingleBlockSize [byte] = %1d \n",TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS)); 
                
                
                if (TST_OuputLocation == 0)/* input buffer != output buffer */
                {
                    for (Block_index = 0 ; Block_index < NumOfBlocks ; Block_index++)/*C2 block loop*/ 
                    {   
                        if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                        { 
                            TST_Status = CRYS_C2_CipherBlock( &TST_ContextID_ptr,     
                                                         TST_C2_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),         
                                                         TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t), 
                                                         TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index)); /*(DxUint8_t *)TST_output_data);*/                      
                            
                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2_Block - Encrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName); 
                             
                        }
                        else
                        {                                       
                            TST_Status = CRYS_C2_CipherBlock( &TST_ContextID_ptr,     
                                                         TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),        
                                                         TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t), 
                                                         TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index)); /*(DxUint8_t *)TST_output_data);*/                                                          

                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2_Block - Decrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);                                                      
                        }   
                   
                    }/*End C2 block loop*/ 
                }
                else /* input buffer = output buffer */ 
                {
                    for (Block_index =0 ; Block_index < NumOfBlocks ; Block_index++)
                    {
                        if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                        {
                            /*Copying the input buffer onto output buffer not to overwrite test data*/
                            DX_VOS_FastMemCpy(TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_C2_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS);  
                        }
                        else
                        {
                            /*Copying the input buffer onto output buffer not to overwrite test data*/
                            DX_VOS_FastMemCpy(TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index), 
                                           TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS);  
                        }
                    }           

                    for (Block_index =0 ; Block_index < NumOfBlocks ; Block_index++)
                    {   
                        TST_Status = CRYS_C2_CipherBlock(&TST_ContextID_ptr,           
                                                   TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),        
                                                   TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t), 
                                                   TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index)); /*(DxUint8_t *)TST_output_data);*/        

                       if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)    
             {
                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2_Block - Encrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName); 
             }
                       else 
             {
                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2_Block - Decrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
             }
                        
                    }
                
                }
                    
                /* calling the Free function */ 
                /*---------------------------*/     
                TST_Status = CRYS_C2_CipherFree( &TST_ContextID_ptr );
                
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2_Free",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);

                    
                            
                /* Compare the result to expected result */ 
                /*---------------------------------------*/ 
                if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)  
                {
                TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_C2_Acceptance_TestData[TST_index].TST_output_data ,
                                                    TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data ,
                                                   TST_C2_Acceptance_TestData[TST_index].TST_dataSize);
                }
                else
                {
                TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_C2_Acceptance_TestData[TST_index].TST_output_data ,
                                                    TST_C2_Acceptance_TestData[TST_index].TST_input_data,
                                                    TST_C2_Acceptance_TestData[TST_index].TST_dataSize);                
                }
                
                /*Print the outputted and then the expected result after mem compare */
                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                            "\n Data outputted by engine [output buffer]--\n",
                                            TST_C2_Acceptance_TestData[TST_index].TST_output_data, 
                                            TST_C2_Acceptance_TestData[TST_index].TST_dataSize); 
                                            
                if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                {
                    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                                "\n Data Expected by engine [expected buffer - encrypt]--\n",
                                                TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data,
                                                TST_C2_Acceptance_TestData[TST_index].TST_dataSize);             
                }                                           
                else
                {
                    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                                "\n Data Expected by engine [input buffer - for decrypt]--\n",
                                                TST_C2_Acceptance_TestData[TST_index].TST_input_data,
                                                TST_C2_Acceptance_TestData[TST_index].TST_dataSize);             
                }                               

                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);

                
            }/* End of TST_ATP_EncryptDecryptFlag*/ 
        }/*End of TST_index//TST_NumberOf_C2_AcceptanceTests*/     
    } /* End of TST_OuputLocation loop*/
  return TST_Status; 

 EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}/* End of CRYS_ATP_TST_C2_Acceptance_NON_integrated*/ 


/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_C2_Acceptance_Integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * C2cription:                                                                 
 *  This function Is a Acceptance test for C2 integrated API                           
 *  This function Encrypts and Decrypts known vectors using C2 mode
 *  C2                   - CBC/ECB
 *  Vector sizes used (in bytes) - 16/32/512/1536           
 *  Key Size used (in bits)     - 128/192/256                               
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the CRYS_C2 function to use the C2 encryption/decryption process
 * 2. Compare the outputted result to the expected one                                                   
 *
 ******************************************************************************/    
CRYSError_t CRYS_ATP_TST_C2_Acceptance_Integrated ( void ) 
{

    /********* TST Variables Definitions ************/
    int         TST_index, Block_index ,NumOfBlocks;
    CRYSError_t TST_Status=0;
    int         TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_C2_Acceptance_NON_integrated";     
    int TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS=CRYS_C2_BLOCK_SIZE_IN_BYTES;  
    /********* TST Variables initialization *********/
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************* \n")); 
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ** CRYS_ATP_TST_C2_Acceptance_Integrated Tests     ********************* \n"));     
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************* \n \n"));

    
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++) 
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_C2_AcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++) /*Select mode or operation  
                                                                                                      TST_OperationMode = 0 == Encrypt
                                                                                                      TST_OperationMode = 1 == Decrypt*/
            {
                if (TST_OuputLocation == 0)/*Select output buffer*/ 
                {   
                    /* output buffer != input buffer    */
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2A.%d]  **\n",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_index));   
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer != input buffer                                       \n"));                    
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
                }
                else
                {
                    /* output buffer == input buffer    */
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************************************************************ \n"));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2B.%d]   **\n",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_index));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer == input buffer (output buffer)                         \n"));                      
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************************************************************ \n"));
                }
                
                TST_Status = TESTPASS;
                NumOfBlocks = TST_C2_Acceptance_TestData[TST_index].TST_dataSize/TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS;
                        
                /* calling the C2 integrated function */
                /*-------------------------------------*/ 
                if (TST_OuputLocation == 0)/* input buffer != output buffer */
                {
                    if (TST_ATP_EncryptDecryptFlag ==0) 
                    {
                        TST_ATP_StartPerformanceTimer(&TST_Timer);

                        TST_Status = CRYS_C2_Cipher(&TST_C2_Acceptance_TestData[TST_index].TST_Key,
                                                 TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
                                                 TST_C2_Acceptance_TestData[TST_index].TST_OperationMode,
                                                 TST_C2_Acceptance_TestData[TST_index].TST_input_data, 
                                                 TST_C2_Acceptance_TestData[TST_index].TST_dataSize, 
                                                 TST_C2_Acceptance_TestData[TST_index].TST_output_data);
                        
                        TST_ATP_GetPerformanceTimer(&TST_Timer);
                        TST_ATP_CalcPerformance(TST_C2_Acceptance_TestData[TST_index].TST_dataSize);
                                             
                        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2 - Encrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);                                                                        
                    }
                    else
                    {
                        TST_ATP_StartPerformanceTimer(&TST_Timer);

                        TST_Status = CRYS_C2_Cipher(&TST_C2_Acceptance_TestData[TST_index].TST_Key,
                                                 TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
                                                 TST_C2_Acceptance_TestData[TST_index].TST_OperationMode,
                                                 TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data,
                                                 TST_C2_Acceptance_TestData[TST_index].TST_dataSize,
                                                 TST_C2_Acceptance_TestData[TST_index].TST_output_data); 
                        
                        TST_ATP_GetPerformanceTimer(&TST_Timer);
                        TST_ATP_CalcPerformance(TST_C2_Acceptance_TestData[TST_index].TST_dataSize);
                        
                        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2 - Decrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);                                        
                    }
                         
                }
                else /* input buffer = output buffer */ 
                {
                    for (Block_index =0 ; Block_index < NumOfBlocks ; Block_index++)
                    {
                        if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                        {
                        /*Copying the input buffer onto output buffer not to overwrite test data*/
                            DX_VOS_FastMemCpy(TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_C2_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS);  
                        }
                        else
                        {
                        /*Copying the input buffer onto output buffer not to overwrite test data*/
                            DX_VOS_FastMemCpy(TST_C2_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data+(TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS*Block_index), 
                                           TST_MAX_SINGLE_C2_BLOCK_SIZE_IN_BYTS);  
                        }
                    } 
                    TST_ATP_StartPerformanceTimer(&TST_Timer);

                    TST_Status = CRYS_C2_Cipher(&TST_C2_Acceptance_TestData[TST_index].TST_Key,
                                             TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
                                             TST_C2_Acceptance_TestData[TST_index].TST_OperationMode,
                                             TST_C2_Acceptance_TestData[TST_index].TST_output_data,
                                             TST_C2_Acceptance_TestData[TST_index].TST_dataSize,
                                             TST_C2_Acceptance_TestData[TST_index].TST_output_data); 

                    TST_ATP_GetPerformanceTimer(&TST_Timer);
                    TST_ATP_CalcPerformance(TST_C2_Acceptance_TestData[TST_index].TST_dataSize);
                                         
                    if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
          {
                        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2 - Encrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
          }
                    else
          {
                        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_C2 - Decrypt",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
          }
                         
                }   
                
                /* Debug massages */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,TST_C2_Acceptance_TestData[TST_index].TST_dataSize));
                            
                /* Compare the result to expected result */ 
                /*---------------------------------------*/                                                             
                if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)  
                {
                TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_C2_Acceptance_TestData[TST_index].TST_output_data ,
                                                    TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data ,
                                                    TST_C2_Acceptance_TestData[TST_index].TST_dataSize);
                }
                else
                {
                TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_C2_Acceptance_TestData[TST_index].TST_output_data ,
                                                    TST_C2_Acceptance_TestData[TST_index].TST_input_data,
                                                    TST_C2_Acceptance_TestData[TST_index].TST_dataSize);                
                }

                /*Print the outputted and then the expected result after mem compare */
                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                            "\n Data outputted by engine [output buffer]--\n",
                                            TST_C2_Acceptance_TestData[TST_index].TST_output_data, 
                                            TST_C2_Acceptance_TestData[TST_index].TST_dataSize); 
                                            
                if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                {
                    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                                "\n Data Expected by engine [expected buffer - encrypt]--\n",
                                                TST_C2_Acceptance_TestData[TST_index].TST_Expected_output_data,
                                                TST_C2_Acceptance_TestData[TST_index].TST_dataSize);             
                }                                           
                else
                {
                    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                                "\n Data Expected by engine [input buffer - for decrypt]--\n",
                                                TST_C2_Acceptance_TestData[TST_index].TST_input_data,
                                                TST_C2_Acceptance_TestData[TST_index].TST_dataSize);             
                }                   
                
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_C2_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
                
            }/* End of TST_ATP_EncryptDecryptFlag*/ 
        }/*End of TST_index//TST_NumberOf_C2_AcceptanceTests*/     
    } /* End of TST_OuputLocation loop*/
  return TST_Status;

 EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}/* End of CRYS_ATP_TST_C2_Acceptance_Integrated */
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_HASH_Acceptance_NON_integrated         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for HASH non integrated API's                            
 *  This function HASH known vectors using SHA1 and MD5
 *  Vector sizes used (in bytes) - 16/32/512/1536                                 
 * Algorithm:       
 * 1. Call the CRYS_HASH_Init function to start the encryption/decryption process
 * 2. Call the CRYS_HASH_Update - This function is called N times
 *                                (N = number of blocks in data each block is 16byte)
 * 3. Call the CRYS_HASH_Finish to end the HASH process and get the Digest result
 * 4. Compare the outputted result to the expected one                                                   
 *
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_C2_HASH_Acceptance_NON_integrated ( void )
{

    /********* TST Variables Definitions ************/
    int                     TST_index, Block_index ,NumOfBlocks;
    CRYSError_t             TST_Status=0;

    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_HASH_Acceptance_NON_integrated";
    CRYS_C2HASHUserContext_t  TST_ContextID_ptr;

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************************************* \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ATP_TST_HASH_Acceptance_NON_integrated Tests ******************** \n"));        
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    
        for (TST_index =0 ; TST_index < TST_NumberOfC2HASHAcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_index));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
            
            TST_Status = TESTPASS;
                    
            /* calling the HASH init function */
            /*--------------------------------*/
            TST_Status = CRYS_C2_HASH_Init(&TST_ContextID_ptr);                        
                             
            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH_Init",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
 
            
            /* calling the HASH Update function */
            /*----------------------------------*/    
            NumOfBlocks = TST_C2_HASH_Acceptance_TestData[TST_index].TST_input_dataSize/TST_MAX_SINGLE_C2_HASH_BLOCK_SIZE_IN_BYTS;
                            
            /* Debug massages */
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"number of blocks = %1d \n",NumOfBlocks));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,TST_C2_HASH_Acceptance_TestData[TST_index].TST_input_dataSize));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"SingleBlockSize [byte] = %1d \n",TST_MAX_SINGLE_C2_HASH_BLOCK_SIZE_IN_BYTS));
            
            for (Block_index = 0 ; Block_index < NumOfBlocks ; Block_index++)/*HASH block loop*/
            {   
                             
                TST_Status = CRYS_C2_HASH_Update(&TST_ContextID_ptr,
                                              TST_C2_HASH_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_C2_HASH_BLOCK_SIZE_IN_BYTS*Block_index),
                                              TST_MAX_SINGLE_C2_HASH_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t));                       
                          
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH_Update",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
          
                                          
            }/*End HASH block loop*/

                            
            /* calling the Finish function */
            /*-----------------------------*/       
            TST_Status = CRYS_C2_HASH_Finish(&TST_ContextID_ptr,
                                                TST_C2_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff);
            
            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH_Finish",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
               
                        
            /* Compare the result to expected result and then Print the expected Vs Outputted*/
            /*------------------------------------------------------------------------------*/
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_C2_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_C2_HASH_Acceptance_TestData[TST_index].TST_C2_Expected_output_data ,
                                                          TST_C2_HASH_Acceptance_TestData[TST_index].TST_C2_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           (DxUint8_t*)TST_C2_HASH_Acceptance_TestData[TST_index].TST_C2_Expected_output_data,
                                           CRYS_C2_BLOCK_SIZE_IN_WORDS);
            
                
            ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                        "\nData outputted by engine [output buffer]--\n",
                                        (DxUint8_t *)TST_C2_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff,
                                        CRYS_HASH_RESULT_SIZE_IN_WORDS*sizeof(DxUint32_t));                   

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);

            
        }/*End of TST_index//TST_NumberOfAcceptanceTests*/      
    
  return TST_Status;
 
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
} /*End of test*/
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_HASH_Acceptance_Integrated         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for HASH integrated API                          
 *  This function HASH known vectors using SHA1 and MD5
 *  Vector sizes used (in bytes) - 16/32/512                                                         
 * Algorithm:       
 * 1. Call the CRYS_HASH function to use the HASH process
 * 2. Compare the outputted result to the expected one                                                   
 *
 ******************************************************************************/
      
CRYSError_t CRYS_ATP_TST_C2_HASH_Acceptance_Integrated ( void )
{

    /********* TST Variables Definitions ************/
    int         TST_index;
    CRYSError_t TST_Status=0;

    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_HASH_Acceptance_Integrated";        
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************************************* \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ATP_TST_HASH_Acceptance_Integrated Tests ******************** \n"));        
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    
        for (TST_index =0 ; TST_index < TST_NumberOfC2HASHAcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_index));
    
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
            
            TST_Status = TESTPASS;
            
            /* Debug massages */
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,TST_C2_HASH_Acceptance_TestData[TST_index].TST_input_dataSize));
                    
            /* calling the HASH function */
            /*---------------------------*/
            TST_ATP_StartPerformanceTimer(&TST_Timer);

            TST_Status = CRYS_C2_HASH(TST_C2_HASH_Acceptance_TestData[TST_index].TST_input_data,
                                      TST_C2_HASH_Acceptance_TestData[TST_index].TST_input_dataSize,
                                      TST_C2_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff);

            TST_ATP_GetPerformanceTimer(&TST_Timer);
            TST_ATP_CalcPerformance(TST_C2_HASH_Acceptance_TestData[TST_index].TST_input_dataSize);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);

                        
            /* Compare the result to expected result and then Print the expected Vs Outputted*/
            /*------------------------------------------------------------------------------*/
            
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_C2_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_C2_HASH_Acceptance_TestData[TST_index].TST_C2_Expected_output_data ,
                                                          TST_C2_HASH_Acceptance_TestData[TST_index].TST_C2_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           (DxUint8_t*)TST_C2_HASH_Acceptance_TestData[TST_index].TST_C2_Expected_output_data,
                                           CRYS_C2_BLOCK_SIZE_IN_WORDS);
                            
               ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                        "\nData outputted by engine [output buffer]--\n",
                                        (DxUint8_t *)TST_C2_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff,
                                        CRYS_HASH_RESULT_SIZE_IN_WORDS*sizeof(DxUint32_t));                   

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_C2_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
              
        }/*End of TST_index//TST_NumberOfAcceptanceTests*/      
    
  return TST_Status;
    
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
} /*End of test*/
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
CRYSError_t CRYS_ATP_TST_C2_Acceptance_OneWayFunc()
{
  int  TST_index;
    CRYSError_t TST_Status=0;
    char   TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_One_Way_Function_Acceptance";        
  
 
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************************************* \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ATP_TST_One_Way_Function_Acceptance Tests ******************* \n"));        
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    
        for (TST_index =0 ; TST_index < TST_NumberOfC2OneWayFuncAcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_Name,TST_index));
    
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
            
            TST_Status = TESTPASS;
            
            /* Debug massages */
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_input_dataSize));
                    
            /* calling the HASH function */
            /*---------------------------*/
            TST_ATP_StartPerformanceTimer(&TST_Timer);

           
      TST_Status = CRYS_C2_OneWayFunc( TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_Key,
                        TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_input_data,
                                                TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_ResultBuff);

            TST_ATP_GetPerformanceTimer(&TST_Timer);
            TST_ATP_CalcPerformance(TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_input_dataSize);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH",TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);

                        
            /* Compare the result to expected result and then Print the expected Vs Outputted*/
            /*------------------------------------------------------------------------------*/
            
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_ResultBuff ,
                                                          TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_OneWayFunc_Expected_output_data ,
                                                          TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_input_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_OneWayFunc_Expected_output_data,
                                           CRYS_C2_BLOCK_SIZE_IN_WORDS);
                            
               ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                        "\nData outputted by engine [output buffer]--\n",
                                        (DxUint8_t *)TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_ResultBuff,
                                        CRYS_HASH_RESULT_SIZE_IN_WORDS*sizeof(DxUint32_t));                   

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_C2_OneWayFunc_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
              

    }/*End of TST_index//TST_NumberOfAcceptanceTests*/      
return TST_Status;
  
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}/*End of test*/
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
